/* Autogenerated file. Do not edit manually. */
/* tslint:disable */
/* eslint-disable */

import { Signer, BigNumberish } from "ethers";
import { Provider, TransactionRequest } from "@ethersproject/providers";
import { Contract, ContractFactory, Overrides } from "@ethersproject/contracts";

import type { PositionManager } from "../PositionManager";

export class PositionManager__factory extends ContractFactory {
  constructor(signer?: Signer) {
    super(_abi, _bytecode, signer);
  }

  deploy(
    _poolManager: string,
    _permit2: string,
    _unsubscribeGasLimit: BigNumberish,
    _tokenDescriptor: string,
    overrides?: Overrides
  ): Promise<PositionManager> {
    return super.deploy(
      _poolManager,
      _permit2,
      _unsubscribeGasLimit,
      _tokenDescriptor,
      overrides || {}
    ) as Promise<PositionManager>;
  }
  getDeployTransaction(
    _poolManager: string,
    _permit2: string,
    _unsubscribeGasLimit: BigNumberish,
    _tokenDescriptor: string,
    overrides?: Overrides
  ): TransactionRequest {
    return super.getDeployTransaction(
      _poolManager,
      _permit2,
      _unsubscribeGasLimit,
      _tokenDescriptor,
      overrides || {}
    );
  }
  attach(address: string): PositionManager {
    return super.attach(address) as PositionManager;
  }
  connect(signer: Signer): PositionManager__factory {
    return super.connect(signer) as PositionManager__factory;
  }
  static connect(
    address: string,
    signerOrProvider: Signer | Provider
  ): PositionManager {
    return new Contract(address, _abi, signerOrProvider) as PositionManager;
  }
}

const _abi = [
  {
    inputs: [
      {
        internalType: "contract IPoolManager",
        name: "_poolManager",
        type: "address",
      },
      {
        internalType: "contract IAllowanceTransfer",
        name: "_permit2",
        type: "address",
      },
      {
        internalType: "uint256",
        name: "_unsubscribeGasLimit",
        type: "uint256",
      },
      {
        internalType: "contract IPositionDescriptor",
        name: "_tokenDescriptor",
        type: "address",
      },
    ],
    stateMutability: "nonpayable",
    type: "constructor",
  },
  {
    inputs: [
      {
        internalType: "uint256",
        name: "tokenId",
        type: "uint256",
      },
      {
        internalType: "address",
        name: "subscriber",
        type: "address",
      },
    ],
    name: "AlreadySubscribed",
    type: "error",
  },
  {
    inputs: [],
    name: "ContractLocked",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "uint256",
        name: "deadline",
        type: "uint256",
      },
    ],
    name: "DeadlinePassed",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "Currency",
        name: "currency",
        type: "address",
      },
    ],
    name: "DeltaNotNegative",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "Currency",
        name: "currency",
        type: "address",
      },
    ],
    name: "DeltaNotPositive",
    type: "error",
  },
  {
    inputs: [],
    name: "GasLimitTooLow",
    type: "error",
  },
  {
    inputs: [],
    name: "InputLengthMismatch",
    type: "error",
  },
  {
    inputs: [],
    name: "InvalidContractSignature",
    type: "error",
  },
  {
    inputs: [],
    name: "InvalidSignature",
    type: "error",
  },
  {
    inputs: [],
    name: "InvalidSignatureLength",
    type: "error",
  },
  {
    inputs: [],
    name: "InvalidSigner",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "uint128",
        name: "maximumAmount",
        type: "uint128",
      },
      {
        internalType: "uint128",
        name: "amountRequested",
        type: "uint128",
      },
    ],
    name: "MaximumAmountExceeded",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "uint128",
        name: "minimumAmount",
        type: "uint128",
      },
      {
        internalType: "uint128",
        name: "amountReceived",
        type: "uint128",
      },
    ],
    name: "MinimumAmountInsufficient",
    type: "error",
  },
  {
    inputs: [],
    name: "NoCodeSubscriber",
    type: "error",
  },
  {
    inputs: [],
    name: "NoSelfPermit",
    type: "error",
  },
  {
    inputs: [],
    name: "NonceAlreadyUsed",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "caller",
        type: "address",
      },
    ],
    name: "NotApproved",
    type: "error",
  },
  {
    inputs: [],
    name: "NotPoolManager",
    type: "error",
  },
  {
    inputs: [],
    name: "NotSubscribed",
    type: "error",
  },
  {
    inputs: [],
    name: "SignatureDeadlineExpired",
    type: "error",
  },
  {
    inputs: [],
    name: "Unauthorized",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "uint256",
        name: "action",
        type: "uint256",
      },
    ],
    name: "UnsupportedAction",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "subscriber",
        type: "address",
      },
      {
        internalType: "bytes",
        name: "reason",
        type: "bytes",
      },
    ],
    name: "Wrap__ModifyLiquidityNotificationReverted",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "subscriber",
        type: "address",
      },
      {
        internalType: "bytes",
        name: "reason",
        type: "bytes",
      },
    ],
    name: "Wrap__SubscriptionReverted",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "subscriber",
        type: "address",
      },
      {
        internalType: "bytes",
        name: "reason",
        type: "bytes",
      },
    ],
    name: "Wrap__TransferNotificationReverted",
    type: "error",
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        internalType: "address",
        name: "owner",
        type: "address",
      },
      {
        indexed: true,
        internalType: "address",
        name: "spender",
        type: "address",
      },
      {
        indexed: true,
        internalType: "uint256",
        name: "id",
        type: "uint256",
      },
    ],
    name: "Approval",
    type: "event",
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        internalType: "address",
        name: "owner",
        type: "address",
      },
      {
        indexed: true,
        internalType: "address",
        name: "operator",
        type: "address",
      },
      {
        indexed: false,
        internalType: "bool",
        name: "approved",
        type: "bool",
      },
    ],
    name: "ApprovalForAll",
    type: "event",
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        internalType: "uint256",
        name: "tokenId",
        type: "uint256",
      },
      {
        indexed: true,
        internalType: "address",
        name: "subscriber",
        type: "address",
      },
    ],
    name: "Subscription",
    type: "event",
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        internalType: "address",
        name: "from",
        type: "address",
      },
      {
        indexed: true,
        internalType: "address",
        name: "to",
        type: "address",
      },
      {
        indexed: true,
        internalType: "uint256",
        name: "id",
        type: "uint256",
      },
    ],
    name: "Transfer",
    type: "event",
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        internalType: "uint256",
        name: "tokenId",
        type: "uint256",
      },
      {
        indexed: true,
        internalType: "address",
        name: "subscriber",
        type: "address",
      },
    ],
    name: "Unsubscription",
    type: "event",
  },
  {
    inputs: [],
    name: "DOMAIN_SEPARATOR",
    outputs: [
      {
        internalType: "bytes32",
        name: "",
        type: "bytes32",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "spender",
        type: "address",
      },
      {
        internalType: "uint256",
        name: "id",
        type: "uint256",
      },
    ],
    name: "approve",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "owner",
        type: "address",
      },
    ],
    name: "balanceOf",
    outputs: [
      {
        internalType: "uint256",
        name: "",
        type: "uint256",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "uint256",
        name: "",
        type: "uint256",
      },
    ],
    name: "getApproved",
    outputs: [
      {
        internalType: "address",
        name: "",
        type: "address",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "uint256",
        name: "tokenId",
        type: "uint256",
      },
    ],
    name: "getPoolAndPositionInfo",
    outputs: [
      {
        components: [
          {
            internalType: "Currency",
            name: "currency0",
            type: "address",
          },
          {
            internalType: "Currency",
            name: "currency1",
            type: "address",
          },
          {
            internalType: "uint24",
            name: "fee",
            type: "uint24",
          },
          {
            internalType: "int24",
            name: "tickSpacing",
            type: "int24",
          },
          {
            internalType: "contract IHooks",
            name: "hooks",
            type: "address",
          },
        ],
        internalType: "struct PoolKey",
        name: "poolKey",
        type: "tuple",
      },
      {
        internalType: "PositionInfo",
        name: "info",
        type: "uint256",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "uint256",
        name: "tokenId",
        type: "uint256",
      },
    ],
    name: "getPositionLiquidity",
    outputs: [
      {
        internalType: "uint128",
        name: "liquidity",
        type: "uint128",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        components: [
          {
            internalType: "Currency",
            name: "currency0",
            type: "address",
          },
          {
            internalType: "Currency",
            name: "currency1",
            type: "address",
          },
          {
            internalType: "uint24",
            name: "fee",
            type: "uint24",
          },
          {
            internalType: "int24",
            name: "tickSpacing",
            type: "int24",
          },
          {
            internalType: "contract IHooks",
            name: "hooks",
            type: "address",
          },
        ],
        internalType: "struct PoolKey",
        name: "key",
        type: "tuple",
      },
      {
        internalType: "uint160",
        name: "sqrtPriceX96",
        type: "uint160",
      },
    ],
    name: "initializePool",
    outputs: [
      {
        internalType: "int24",
        name: "",
        type: "int24",
      },
    ],
    stateMutability: "payable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "",
        type: "address",
      },
      {
        internalType: "address",
        name: "",
        type: "address",
      },
    ],
    name: "isApprovedForAll",
    outputs: [
      {
        internalType: "bool",
        name: "",
        type: "bool",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "bytes",
        name: "unlockData",
        type: "bytes",
      },
      {
        internalType: "uint256",
        name: "deadline",
        type: "uint256",
      },
    ],
    name: "modifyLiquidities",
    outputs: [],
    stateMutability: "payable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "bytes",
        name: "actions",
        type: "bytes",
      },
      {
        internalType: "bytes[]",
        name: "params",
        type: "bytes[]",
      },
    ],
    name: "modifyLiquiditiesWithoutUnlock",
    outputs: [],
    stateMutability: "payable",
    type: "function",
  },
  {
    inputs: [],
    name: "msgSender",
    outputs: [
      {
        internalType: "address",
        name: "",
        type: "address",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "bytes[]",
        name: "data",
        type: "bytes[]",
      },
    ],
    name: "multicall",
    outputs: [
      {
        internalType: "bytes[]",
        name: "results",
        type: "bytes[]",
      },
    ],
    stateMutability: "payable",
    type: "function",
  },
  {
    inputs: [],
    name: "name",
    outputs: [
      {
        internalType: "string",
        name: "",
        type: "string",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [],
    name: "nextTokenId",
    outputs: [
      {
        internalType: "uint256",
        name: "",
        type: "uint256",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "owner",
        type: "address",
      },
      {
        internalType: "uint256",
        name: "word",
        type: "uint256",
      },
    ],
    name: "nonces",
    outputs: [
      {
        internalType: "uint256",
        name: "bitmap",
        type: "uint256",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "uint256",
        name: "id",
        type: "uint256",
      },
    ],
    name: "ownerOf",
    outputs: [
      {
        internalType: "address",
        name: "owner",
        type: "address",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "spender",
        type: "address",
      },
      {
        internalType: "uint256",
        name: "tokenId",
        type: "uint256",
      },
      {
        internalType: "uint256",
        name: "deadline",
        type: "uint256",
      },
      {
        internalType: "uint256",
        name: "nonce",
        type: "uint256",
      },
      {
        internalType: "bytes",
        name: "signature",
        type: "bytes",
      },
    ],
    name: "permit",
    outputs: [],
    stateMutability: "payable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "owner",
        type: "address",
      },
      {
        components: [
          {
            components: [
              {
                internalType: "address",
                name: "token",
                type: "address",
              },
              {
                internalType: "uint160",
                name: "amount",
                type: "uint160",
              },
              {
                internalType: "uint48",
                name: "expiration",
                type: "uint48",
              },
              {
                internalType: "uint48",
                name: "nonce",
                type: "uint48",
              },
            ],
            internalType: "struct IAllowanceTransfer.PermitDetails",
            name: "details",
            type: "tuple",
          },
          {
            internalType: "address",
            name: "spender",
            type: "address",
          },
          {
            internalType: "uint256",
            name: "sigDeadline",
            type: "uint256",
          },
        ],
        internalType: "struct IAllowanceTransfer.PermitSingle",
        name: "permitSingle",
        type: "tuple",
      },
      {
        internalType: "bytes",
        name: "signature",
        type: "bytes",
      },
    ],
    name: "permit",
    outputs: [
      {
        internalType: "bytes",
        name: "err",
        type: "bytes",
      },
    ],
    stateMutability: "payable",
    type: "function",
  },
  {
    inputs: [],
    name: "permit2",
    outputs: [
      {
        internalType: "contract IAllowanceTransfer",
        name: "",
        type: "address",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "owner",
        type: "address",
      },
      {
        components: [
          {
            components: [
              {
                internalType: "address",
                name: "token",
                type: "address",
              },
              {
                internalType: "uint160",
                name: "amount",
                type: "uint160",
              },
              {
                internalType: "uint48",
                name: "expiration",
                type: "uint48",
              },
              {
                internalType: "uint48",
                name: "nonce",
                type: "uint48",
              },
            ],
            internalType: "struct IAllowanceTransfer.PermitDetails[]",
            name: "details",
            type: "tuple[]",
          },
          {
            internalType: "address",
            name: "spender",
            type: "address",
          },
          {
            internalType: "uint256",
            name: "sigDeadline",
            type: "uint256",
          },
        ],
        internalType: "struct IAllowanceTransfer.PermitBatch",
        name: "_permitBatch",
        type: "tuple",
      },
      {
        internalType: "bytes",
        name: "signature",
        type: "bytes",
      },
    ],
    name: "permitBatch",
    outputs: [
      {
        internalType: "bytes",
        name: "err",
        type: "bytes",
      },
    ],
    stateMutability: "payable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "owner",
        type: "address",
      },
      {
        internalType: "address",
        name: "operator",
        type: "address",
      },
      {
        internalType: "bool",
        name: "approved",
        type: "bool",
      },
      {
        internalType: "uint256",
        name: "deadline",
        type: "uint256",
      },
      {
        internalType: "uint256",
        name: "nonce",
        type: "uint256",
      },
      {
        internalType: "bytes",
        name: "signature",
        type: "bytes",
      },
    ],
    name: "permitForAll",
    outputs: [],
    stateMutability: "payable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "bytes25",
        name: "poolId",
        type: "bytes25",
      },
    ],
    name: "poolKeys",
    outputs: [
      {
        internalType: "Currency",
        name: "currency0",
        type: "address",
      },
      {
        internalType: "Currency",
        name: "currency1",
        type: "address",
      },
      {
        internalType: "uint24",
        name: "fee",
        type: "uint24",
      },
      {
        internalType: "int24",
        name: "tickSpacing",
        type: "int24",
      },
      {
        internalType: "contract IHooks",
        name: "hooks",
        type: "address",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [],
    name: "poolManager",
    outputs: [
      {
        internalType: "contract IPoolManager",
        name: "",
        type: "address",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "uint256",
        name: "tokenId",
        type: "uint256",
      },
    ],
    name: "positionInfo",
    outputs: [
      {
        internalType: "PositionInfo",
        name: "info",
        type: "uint256",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "uint256",
        name: "nonce",
        type: "uint256",
      },
    ],
    name: "revokeNonce",
    outputs: [],
    stateMutability: "payable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "from",
        type: "address",
      },
      {
        internalType: "address",
        name: "to",
        type: "address",
      },
      {
        internalType: "uint256",
        name: "id",
        type: "uint256",
      },
    ],
    name: "safeTransferFrom",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "from",
        type: "address",
      },
      {
        internalType: "address",
        name: "to",
        type: "address",
      },
      {
        internalType: "uint256",
        name: "id",
        type: "uint256",
      },
      {
        internalType: "bytes",
        name: "data",
        type: "bytes",
      },
    ],
    name: "safeTransferFrom",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "operator",
        type: "address",
      },
      {
        internalType: "bool",
        name: "approved",
        type: "bool",
      },
    ],
    name: "setApprovalForAll",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "uint256",
        name: "tokenId",
        type: "uint256",
      },
      {
        internalType: "address",
        name: "newSubscriber",
        type: "address",
      },
      {
        internalType: "bytes",
        name: "data",
        type: "bytes",
      },
    ],
    name: "subscribe",
    outputs: [],
    stateMutability: "payable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "uint256",
        name: "tokenId",
        type: "uint256",
      },
    ],
    name: "subscriber",
    outputs: [
      {
        internalType: "contract ISubscriber",
        name: "subscriber",
        type: "address",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "bytes4",
        name: "interfaceId",
        type: "bytes4",
      },
    ],
    name: "supportsInterface",
    outputs: [
      {
        internalType: "bool",
        name: "",
        type: "bool",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [],
    name: "symbol",
    outputs: [
      {
        internalType: "string",
        name: "",
        type: "string",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [],
    name: "tokenDescriptor",
    outputs: [
      {
        internalType: "contract IPositionDescriptor",
        name: "",
        type: "address",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "uint256",
        name: "tokenId",
        type: "uint256",
      },
    ],
    name: "tokenURI",
    outputs: [
      {
        internalType: "string",
        name: "",
        type: "string",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "from",
        type: "address",
      },
      {
        internalType: "address",
        name: "to",
        type: "address",
      },
      {
        internalType: "uint256",
        name: "id",
        type: "uint256",
      },
    ],
    name: "transferFrom",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "bytes",
        name: "data",
        type: "bytes",
      },
    ],
    name: "unlockCallback",
    outputs: [
      {
        internalType: "bytes",
        name: "",
        type: "bytes",
      },
    ],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "uint256",
        name: "tokenId",
        type: "uint256",
      },
    ],
    name: "unsubscribe",
    outputs: [],
    stateMutability: "payable",
    type: "function",
  },
  {
    inputs: [],
    name: "unsubscribeGasLimit",
    outputs: [
      {
        internalType: "uint256",
        name: "",
        type: "uint256",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
];

const _bytecode =
  "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";
